#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Res_Description=IP Finder
#AutoIt3Wrapper_Res_Fileversion=1.9
#AutoIt3Wrapper_Res_Language=1033
#AutoIt3Wrapper_Res_requestedExecutionLevel=requireAdministrator
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
;
; KissCloneHunter
; Based on CloneHunter 2.2 code
; Designed and created by Fuhrmanator@gmail.com, 2006-03-15
;
; Updated for 1.12 by PortalDeamon000 2008-09-30
; Updated for 1.12 regular D2 2008-12-05

#include <Date.au3>
#include <GuiConstants.au3>
#include <GuiEdit.au3>
#include <ProgressConstants.au3>
#include <String.au3>
#include <WindowsConstants.au3>

#include <NomadMemory.au3>
#include <MinimizedMsg.au3>

Global Const $VersionInfo = 'KissCloneHunter 1.9'

Global $GameCount = 0
;; handle to controls in the lobby screen - from R1CH and EoN
Global $OFFSET_D2MULTI_SCREEN = 0x6FA09154
Global $OFFSET_D2MULTI_IPADDRESS_ASCII = 0x6FA2B1F8
Global $OFFSET_D2MULTI_LAST_CHAT_MSG = 0x6FBCFC40
Global $OFFSET_GAME_PING = 0x6FBB32BC
;~ Global $OFFSET_D2CLIENT = 0x6FBCB908
Global $OFFSET_GAMEINFO = 0x11B908 ;0x120F0 ;0x6FBCB908
Global $OFFSET_GAMENAME = 0x1A
Global $OFFSET_GAMEPASSWORD = 0x23F

Global $MESSAGE_DIABLO_WALKS_THE_EARTH = "Diablo Walks the Earth"
Global $MESSAGE_STONES_OF_JORDAN_SOLD = "Stones of Jordan Sold to Merchants"

Global $LOBBY_MAIN_CREATE_X			= 600
Global $LOBBY_MAIN_CREATE_Y			= 463
Global $LOBBY_MAIN_JOIN_X			= 706
Global $LOBBY_MAIN_JOIN_Y			= 463
Global $LOBBY_CREATE_HELL_X			= 706
Global $LOBBY_CREATE_HELL_Y			= 375
Global $LOBBY_CREATE_NORM_X			= 439
Global $LOBBY_CREATE_NORM_Y			= 375
Global $LOBBY_CREATE_X				= 706
Global $LOBBY_CREATE_Y				= 375
Global $LOBBY_CREATE_CREATE_GAME_X	= 684
Global $LOBBY_CREATE_CREATE_GAME_Y	= 420

Global $changedip = 0

$DebugForceFind = 0  ;; used for testing only

$UserUniqueGameName = 0
$UserUniqueGamePass = ""
$GameNumber = 0
$GameName = 0
$GamePass = 0
$CurrentIP = 0
$IPList = 0
$HuntSoundFile = @ScriptDir & '\diablo_hunt.wav'
$FoundSoundFile = @ScriptDir & '\tada.wav'
$WindowName = "Diablo II"
$radio_1 = ""
$radio_2 = ""
$input_1 = ""
$input_2 = ""
$input_3 = ""
$input_4 = ""
$input_5 = ""
$input_6 = ""

;; GUI positioning
$GUIWindowWidth = 200
$GUIWindowHeight = 510
if @DesktopWidth < 1024 Then
	$GUIWindowX = 600
Else
	$GUIWindowX = 824
EndIf
$GUIWindowY = 0

$MSG_TimeToNextGame = "Time left:"

Dim $HuntedIPs[4] ;; gets redimensioned later, but we need its scope here

$GameDurationSeconds = 180
$AdjustedGameLengthSeconds = 0

;; Note - some users (including the author) experienced, at times,
;; frequent "failed to join game" errors after a new game is created.
;; Increasing the value below might help, but my experience shows
;; that even at 10 seconds, the problem can still occur.
;; If the delay is too small (e.g., 1 second), "failed to join game"
;; errors occur almost every time. There is likely another reason
;; for this error when delay before new game is higher, possibly
;; packet-loss on the local ISP, using a character that was in a game
;; that recently crashed, etc.

$DelayBeforeNewGameSeconds = 5

;; generate a random letter (a-z) plus a 3-digit number (100-999) for game name prefix
$UserUniqueGameName = Chr(96 + Random(1, 26, 1)) & Random(100, 999, 1) & "-"
$PrivateMessageRecipient = ""
$AntiIdleDelayMS = 30 * 1000  ;; 30 secs

; GUI - startup gui with update option
$startgui = GUICreate($VersionInfo, 330,100)
$button_1 = GuiCtrlCreateButton("Run", 10, 10, 100, 50)
$button_2 = GUICtrlCreateButton("Help - How to Use", 10, 65, 100, -1)
$button_3 = GuiCtrlCreateButton("Cancel", 210, 10, 100, 50)
$button_4 = GUICtrlCreateButton("Check For Updates", 210, 65, 100, -1)
$button_5 = GUICtrlCreateButton("Rename Windows", 110, 25, 100, 70)
GUISetState(@SW_SHOW,$startgui)

While 1
	$msg = GUIGetMsg()
	Select
		Case $msg = $button_1
			GUIDelete($startgui)
            ExitLoop
		Case $msg = $button_2
            ShellExecute("readme.txt")
		Case $msg = $button_3
            Exit
		Case $msg = $button_4
			_Update()
		Case $msg = $button_5
			_winrename()
		Case $msg = $GUI_EVENT_CLOSE
            Exit
	EndSelect
WEnd

;; option param = 16 so window can be moved if needed, smaller font (10 pt?)
;GUIWindowOn ( $VersionInfo, $VersionInfo & ' by Fuhrmanator, based on code by Snarg', $GUIWindowWidth, $GUIWindowHeight, $GUIWindowX, $GUIWindowY, 16, "", 10 )

; cell positioning of all new GUI components
AutoItSetOption("GUICoordMode", 2)
;~ AutoItSetOption("GUIOnEventMode", 1)

; GUI - make it resizable, and force it to top always
$maingui = GUICreate($VersionInfo, $GUIWindowWidth, $GUIWindowHeight, $GUIWindowX, $GUIWindowY, $WS_THICKFRAME, $WS_EX_TOPMOST + $WS_EX_TOOLWINDOW)

GUISetOnEvent($GUI_EVENT_CLOSE, "CLOSEClicked")

$WinNameLabel = GUICtrlCreateLabel("Window: ", 3, 3, $GUIWindowWidth - 10)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
GUICtrlSetFont( -1, 9, 400, 0, "Arial Bold")

;Change IPs BUTTON
GUICtrlCreateButton("Change IPs:",-1,0,75)
GUICtrlSetOnEvent( -1, "ChangeIP")
GUICtrlSetFont( -1, 9, 400, 0, "Arial Bold")
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH )

$IPListLabel = GUICtrlCreateLabel("", 5, -1, $GUIWindowWidth - 85)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
GUICtrlSetFont( -1, 9, 400, 0, "Arial Bold")

;Change Delay BUTTON
GUICtrlCreateButton("Change Delay:",5 - $GUIWindowWidth,0,90)
GUICtrlSetOnEvent( -1, "ChangeDelay")
GUICtrlSetFont( -1, 9, 400, 0, "Arial Bold")
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH )

$GameDurationLabel = GUICtrlCreateLabel("", 5, -1, $GUIWindowWidth - 100)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
GUICtrlSetFont( -1, 9, 400, 0, "Arial Bold")

; Pause BUTTON
$PauseButton = GUICtrlCreateButton("Pause", 5 - $GUIWindowWidth, 0,$GUIWindowWidth - 10)
GUICtrlSetOnEvent( -1, "PauseButton")
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
$HuntPaused = 0
GUICtrlSetState( -1, $GUI_DISABLE)

; Hold Game/Abandon Game BUTTON
$HoldAbandonButton = GUICtrlCreateButton("Hold Game", -1, 0,$GUIWindowWidth - 10)
GUICtrlSetOnEvent( -1, "HoldAbandon")
$HoldGame = 0
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )

; Timer PROGRESS
$ProgressLabel = GUICtrlCreateLabel($MSG_TimeToNextGame, -1, 0, $GUIWindowWidth - 10)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
$Progress = GUICtrlCreateProgress(-1, 0, $GUIWindowWidth - 10, 20, $PBS_SMOOTH)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
GUICtrlSetData(-1, 0)

; KEEP MINIMIZED checkbox
$MinimizedCheckbox = GUICtrlCreateCheckbox( "Run Minimized", -1, 0, $GUIWindowWidth - 10)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
GUICtrlSetState ( -1, $GUI_CHECKED)

; INTERRUPT HUNT ON SOJ sales activity checkbox
$InterruptOnSalesCheckbox = GUICtrlCreateCheckbox( "Hold game on SoJ sale or Walk msg", -1, 0, $GUIWindowWidth - 10)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )
GUICtrlSetState( -1, $GUI_CHECKED)

; Disable warning BEEP before activating a window
$DisableBeepCheckbox = GUICtrlCreateCheckbox( "Disable Warning Beep", -1, 0, $GUIWindowWidth - 10)
GUICtrlSetResizing ( -1, $GUI_DOCKHEIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP )

; Log of messages
$LogText = GUICtrlCreateEdit($VersionInfo & @CRLF & ' by Fuhrmanator, based on code by Snarg' & @CRLF & ' modified for 1.12 by PortalDeamon000' & @CRLF, -1, 0, $GUIWindowWidth - 5, $GUIWindowHeight - 225)
GUICtrlSetResizing($LogText, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKBOTTOM)

AutoItSetOption("WinTitleMatchMode", 3)  ;; exact match

;;==================================================
;; Main code starts here
;;==================================================

VerifyDisplaySettings()

;; intro sound for cool (?) factor
SoundPlay($HuntSoundFile)

AskForAllInfo()

; Display main GUI window
AutoItSetOption("GUIOnEventMode", 1)
GUISetState(@SW_SHOW,$maingui)

;; must have this priv to read d2's memory
_SetPrivilege ("SeDebugPrivilege", 1)

GUICtrlSetData($WinNameLabel, "Window: " & $WindowName)
GUICtrlSetData($IPListLabel, $IPList)
GUICtrlSetData($GameDurationLabel, $GameDurationSeconds & " seconds")

if Not WinExists($WindowName) Then
	GUIDelete($maingui)
	MsgBox(48, "ERROR", "Window: " & $WindowName & " appears not to be running. Exiting...")
	Exit
EndIf
Sleep(100)
;~ ActivateRestoreDiabloWindow()
Sleep(500)
if IsGameActive() Then
	$userResponse = MsgBox(6 + 32 + 262144, $VersionInfo & ": Notice", "KCH has noticed that you are currently in a game already. Do you want to anti-idle this game?" & @CRLF & "Press Continue to anti-idle, or Try Again to have the bot return to lobby and hunt")
    If $userResponse = 2 Then
    ;; user chose to cancel, exit...
        Exit
	ElseIf $userResponse = 11 Then
	;; user chose to camp this game
		If (GUICtrlRead($MinimizedCheckbox) = $GUI_CHECKED) Then WinSetState($WindowName,"",@SW_MINIMIZE)
		getgamenamepass()
	ElseIf $userResponse = 10 Then
	;; user chose to return to lobby and hunt
		ExitGame()
		AppendLineToLogText("Waiting " & $DelayBeforeNewGameSeconds & " seconds before creating game...")
		Sleep($DelayBeforeNewGameSeconds * 1000)
		VerifyLobbyScreenUp()
		If (GUICtrlRead($MinimizedCheckbox) = $GUI_CHECKED) Then WinSetState($WindowName,"",@SW_MINIMIZE)
		_Main()
	EndIf

Else
	VerifyLobbyScreenUp()
	If (GUICtrlRead($MinimizedCheckbox) = $GUI_CHECKED) Then WinSetState($WindowName,"",@SW_MINIMIZE)
EndIf

_Main()
Exit

Func _Main()
	while (1)
    
		CreateGame()
		Sleep(500)
		_SendMinimized($WindowName, '{TAB}')  ;; turn on the info to display gamename/etc

		;; check to see if current game's IP is in list of hunted IPs
		$CurrentIP = Read_Diablo_Memory (GetD2ProcessID(), $OFFSET_D2MULTI_IPADDRESS_ASCII, 'char[16]')
		AppendLineToLogText("Joined game IP: " & $CurrentIP & " at " & _NowCalc())
    
		If IsIPFound($CurrentIP) Then
			AckHuntedIPFound()
		EndIf

		;==============================
		; prepare to wait in the game
		;==============================
	
		;; calculate the game time in seconds
		$AdjustedGameLengthSeconds = $GameDurationSeconds - $DelayBeforeNewGameSeconds

		;; clear the last message seen on the D2 client
		$oldMessage = ""
    
		UnPause()
		GUICtrlSetState($PauseButton, $GUI_ENABLE)

		;; wait in the game, displaying the time remaining and the progress bar
		For $sleepSecond = $AdjustedGameLengthSeconds To 0 Step - 0.5
        
			;;check if ingame and currentip is hunted
			if $changedip = 1 Then
				$changedip = 0
				if IsGameActive() Then
					If IsIPFound($CurrentIP) Then
						AckHuntedIPFound()
					EndIf
				EndIf
			EndIf
			
			$percentComplete = Int(100 * ($AdjustedGameLengthSeconds - $sleepSecond) / $AdjustedGameLengthSeconds)
        
			GUICtrlSetData($ProgressLabel, $MSG_TimeToNextGame & Int($sleepSecond) & " sec.")
			GUICtrlSetData($Progress, $percentComplete)
        
			;; beep to signal that the timer's about to run out
			If $sleepSecond < 5 And $sleepSecond = Int($sleepSecond) Then
				MyBeep()
			EndIf
        
			Sleep(500)
        
			;; if the user pressed the pause button, the variable will be set
			While $HuntPaused = 1
				Sleep(500)
			WEnd
			if $HoldGame = 1 Then
				getgamenamepass()
			EndIf
        
			;; check for SOJ sales and/or Diablo Walks here,
			;; in case it happens while we're waiting for next game
			;; (that would be bad to ignore it!)
			If GetLastChatMessage() <> $oldMessage Then
				$oldMessage = GetLastChatMessage()
;~ 				AppendLineToLogText("New msg -> " & $oldMessage)
				;; only check for messages if user has requested
				If (GUICtrlRead($InterruptOnSalesCheckbox) = $GUI_CHECKED) Then
					If StringLeft($oldMessage, StringLen($MESSAGE_DIABLO_WALKS_THE_EARTH)) = $MESSAGE_DIABLO_WALKS_THE_EARTH Then
						InterruptHunt()
					ElseIf StringInStr($oldMessage, $MESSAGE_STONES_OF_JORDAN_SOLD, 1) Then
						InterruptHunt()
					EndIf
				EndIf
			EndIf
        
		Next
    
		GUICtrlSetState($PauseButton, $GUI_DISABLE)
		GUICtrlSetData($Progress, 0)
    
		ExitGame()

		AppendLineToLogText("Waiting " & $DelayBeforeNewGameSeconds & " seconds before creating game...")
		Sleep($DelayBeforeNewGameSeconds * 1000)
    
	WEnd
EndFunc

; =========== Subroutines ===============

Func VerifyDisplaySettings()
    
    If @DesktopWidth < 800 Or @DesktopHeight < 600 Then
        MsgBox(16 + 0, "Display settings incorrect", "Sorry. For this program to function properly, " & @CRLF & "your screen's resolution must be at least 800 x 600")
        Exit
    EndIf
    
EndFunc   ;==>VerifyDisplaySettings 

; ===========================================
Func AskForAllInfo()
	; GUI - ask for info gui
$infogui = GUICreate($VersionInfo,300,460)
$label_0 = GUICtrlCreateLabel("Difficulty:",10,10,60,20)
GUICtrlSetFont($label_0,10)
$radio_1 = GUICtrlCreateRadio("Normal",0,-1,60,20)
$radio_2 = GUICtrlCreateRadio("Hell",0,-1,50,20)
GUICtrlSetState($radio_2,$GUI_CHECKED)
$label_1 = GUICtrlCreateLabel("Window Title:",-170,10,85,20)
GUICtrlSetFont($label_1,10)
$input_1 = GUICtrlCreateInput($WindowName,0,-1,195,20)
$label_2 = GUICtrlCreateLabel("Enter the name of your Diablo II window here. If using multiple windows, they must all have unique names.",-280,3,280,30)
$label_3 = GUICtrlCreateLabel("IP List:",-1,5,50,20)
GUICtrlSetFont($label_3,10)
$input_2 = GUICtrlCreateInput("66, 141",0,-1,230,20)
$label_4 = GUICtrlCreateLabel("Please enter a list of IPs to search for, separated by commas. Only enter the last part of an IP address, not the entire IP address.",-280,3,280,40)
$label_5 = GUICtrlCreateLabel("Game Duration:",-1,5,95,20)
GUICtrlSetFont($label_5,10)
$input_3 = GUICtrlCreateInput($GameDurationSeconds,0,-1,185,20)
$label_6 = GUICtrlCreateLabel("Please enter how many seconds (at least 10) a game should last. Note: 180 seconds is generally a safe number to avoid getting IP banned after many tries.",-280,3,280,40)
$label_7 = GUICtrlCreateLabel("Game Name Prefix:",-1,5,115,20)
GUICtrlSetFont($label_7,10)
$input_4 = GUICtrlCreateInput($UserUniqueGameName,0,-1,165,20)
$label_8 = GUICtrlCreateLabel("Please enter a prefix for the games to use (should be unique)",-280,3,280,30)
$label_9 = GUICtrlCreateLabel("Optional Game Password:",-1,5,155,20)
GUICtrlSetFont($label_9,10)
$input_5 = GUICtrlCreateInput($UserUniqueGamePass,0,-1,125,20)
$label_10 = GUICtrlCreateLabel("Entering a password here will set a custom password.  Leave blank for default game number as password.",-280,3,280,30)
$label_11 = GUICtrlCreateLabel("Optional Notification:",-1,5,125,20)
GUICtrlSetFont($label_11,10)
$input_6 = GUICtrlCreateInput($PrivateMessageRecipient,0,-1,155,20)
$label_12 = GUICtrlCreateLabel("Please enter the Battle.net account ID that should receive a private message if an IP has been found (do not include the *). Leave blank for no message.",-280,3,280,40)
$nxt_button = GUICtrlCreateButton("Next -->",-280,10)
GUISetState(@SW_SHOW,$infogui)

While 1
	$msg = GUIGetMsg()
	Select
		Case $msg = $nxt_button
			$checkval = checkinfo()
			if $checkval = 0 Then
				GUIDelete($infogui)
				ExitLoop
			ElseIf $checkval = 1 Then
				GUICtrlSetState($input_1,$GUI_FOCUS)
			ElseIf $checkval = 2 Then
				GUICtrlSetState($input_2,$GUI_FOCUS)
			ElseIf $checkval = 3 Then
				GUICtrlSetState($input_3,$GUI_FOCUS)
			ElseIf $checkval = 4 Then
				GUICtrlSetState($input_4,$GUI_FOCUS)
			ElseIf $checkval = 5 Then
				GUICtrlSetState($input_5,$GUI_FOCUS)
			ElseIf $checkval = 6 Then
				GUICtrlSetState($input_6,$GUI_FOCUS)
			EndIf
		Case $msg = $GUI_EVENT_CLOSE
            Exit
	EndSelect
WEnd

    AskToPrepareClient()
    
EndFunc

; ===========================================

Func checkinfo()
	if GUICtrlRead($input_1) = "" Then
		MsgBox(48,$VersionInfo,"Window Title must have a unique value!")
		Return 1
	EndIf
	$InputIPList = StringStripWS(GUICtrlRead($input_2), 8)  ;; strip all spaces
	$SplitIPs = StringSplit($InputIPList, ",")  ;; breaks IPs into separate array entries
	if Not $SplitIPs[0] >= 1 Then
		MsgBox(48,$VersionInfo,"Enter ips as integers in the format xx,yy,zz")
		Return 2
	EndIf
	if Not (GUICtrlRead($input_3) >= 10 And StringIsInt(GUICtrlRead($input_3))) Then
		MsgBox(48,$VersionInfo,"Game Duration must be an integer and greater than 10 seconds!")
		Return 3
	EndIf

	if GUICtrlRead($input_4) = "" Or StringLen(GUICtrlRead($input_4)) > 10 Then
		MsgBox(48,$VersionInfo,"Game Prefix must exist and cannot exceed 10 characters!")
		Return 4
	EndIf

	Local $val = GUICtrlRead($input_4)
	for $i=1 to StringLen($val)
		Local $val2 = StringMid($val,$i,1)
		if Not (StringIsAlNum($val2) or ($val2 = "-") or ($val2 = "_") or ($val2 = "'") or (($val2 = " ") And ($i > 1))) Then
			MsgBox(48,$VersionInfo,"Game Prefix cannot contain those invalid characters")
			Return 4
		EndIf
	Next
	
	if StringLen(GUICtrlRead($input_5)) > 10 Then
		MsgBox(48,$VersionInfo,"Game Password cannot exceed 10 characters!")
		Return 5
	EndIf
	
	Local $val = GUICtrlRead($input_5)
	for $i=1 to StringLen($val)
		Local $val2 = StringMid($val,$i,1)
		if Not (StringIsAlNum($val2) or ($val2 = "-") or ($val2 = "_") or ($val2 = "'") or (($val2 = " ") And ($i > 1))) Then
			MsgBox(48,$VersionInfo,"Game Password cannot contain those invalid characters")
			Return 5
		EndIf
	Next
	
	;; first element of array after Split is number of returned elements
    ReDim $HuntedIPs [$SplitIPs[0]]
    $IPList = ""
	For $r = 1 To UBound($SplitIPs) - 1
		if Not StringIsInt($SplitIPs[$r]) Then
			MsgBox(48,$VersionInfo,"Enter ips as integers in the format xx,yy,zz")
			Return 2
		EndIf
		$HuntedIPs[$r - 1] = $SplitIPs[$r]  ;; copy IP into hunting list
        If $IPList = "" Then
            $IPList = $SplitIPs[$r]  ;; init to first split IP
        Else
            $IPList = $IPList & ", " & $SplitIPs[$r]
        EndIf
    Next
	$WindowName = GUICtrlRead($input_1)
	$GameDurationSeconds = GUICtrlRead($input_3)
	$UserUniqueGameName = GUICtrlRead($input_4)
	$UserUniqueGamePass = GUICtrlRead($input_5)
	$PrivateMessageRecipient = GUICtrlRead($input_6)
	if GUICtrlRead($radio_1) = $GUI_CHECKED Then
		$LOBBY_CREATE_X = $LOBBY_CREATE_NORM_X
		$LOBBY_CREATE_Y = $LOBBY_CREATE_NORM_Y
	EndIf
	if GUICtrlRead($radio_2) = $GUI_CHECKED Then
		$LOBBY_CREATE_X = $LOBBY_CREATE_HELL_X
		$LOBBY_CREATE_Y = $LOBBY_CREATE_HELL_Y
	EndIf
	Return 0
EndFunc

; ===========================================

Func AskToPrepareClient()
    
    $startResponse = MsgBox(1, $VersionInfo & ": Prepare D2 Client", "I will begin searching for the following IPs: " & $IPList & @CRLF & @CRLF & "Note: To stop me at any time, click my AutoIt icon in the system tray for a menu of options." & @CRLF & @CRLF & "Before continuing, make sure you have done the following:" & @CRLF & "1. Start Diablo in a separate window (-w option) and make sure the resolution is set to 800x600." & @CRLF & "2. Log in to your realm." & @CRLF & "3. Open a character that can create Hell-level games (make sure the Create button is on the screen).")
    
    If $startResponse = 2 Then  ;; cancel button
        Exit
    EndIf
    
EndFunc   ;==>AskToPrepareClient 

; ===========================================

Func getgamenamepass()
	$GameinfoStart = _ProcessGetLoadedModules(GetD2ProcessID())
;~ 	AppendLineToLogText("GameinfoStart: " & $GameinfoStart + $OFFSET_GAMEINFO)
	$Gameinfo = Read_Diablo_Memory (GetD2ProcessID(), $GameinfoStart + $OFFSET_GAMEINFO, 'dword')
;~ 	AppendLineToLogText("Gameinfo: " & $Gameinfo)
	$GameinfoName = $Gameinfo + $OFFSET_GAMENAME
	$GameinfoPass = $Gameinfo + $OFFSET_GAMEPASSWORD
	$GameName = Read_Diablo_Memory (GetD2ProcessID(), $GameinfoName, 'char[24]')
;~ 	AppendLineToLogText("GameName: " & $GameName)
	$GamePass = Read_Diablo_Memory (GetD2ProcessID(), $GameinfoPass, 'char[24]')
;~ 	AppendLineToLogText("GamePass: " & $GamePass)
	HoldManualGame()
EndFunc

; ===========================================

Func ActivateRestoreDiabloWindow()
    
    WinActivate($WindowName)
    WinWaitActive($WindowName,"",3)
    WinSetState($WindowName, "", @SW_RESTORE)
    Sleep ( 500 )
    
EndFunc   ;==>ActivateRestoreDiabloWindow 

; ===========================================

Func ChangeIP()
	Local $val = 1
	$IPList_old = $IPList
	While $val = 1
		$val = 0
		Do
			$InputIPList = InputBox($VersionInfo & ": IP List", "Please enter a list of IPs to search for, separated by commas. Only enter the last part of an IP address, not the entire IP address.", $IPList, " M","","","","",30)
        
			If @error <> 0 Then
				$InputIPList = StringStripWS($IPList_old, 8)  ;; strip all spaces
				$SplitIPs = StringSplit($InputIPList, ",")  ;; breaks IPs into separate array entries
				
				ReDim $HuntedIPs [$SplitIPs[0]]
				$IPList = ""
    
				For $r = 1 To UBound($SplitIPs) - 1
					$HuntedIPs[$r - 1] = $SplitIPs[$r]  ;; copy IP into hunting list
					If $IPList = "" Then
						$IPList = $SplitIPs[$r]  ;; init to first split IP
					Else
						$IPList = $IPList & ", " & $SplitIPs[$r]
					EndIf
        
				Next
				Return
			EndIf
        
			$InputIPList = StringStripWS($InputIPList, 8)  ;; strip all spaces
			$SplitIPs = StringSplit($InputIPList, ",")  ;; breaks IPs into separate array entries
		Until $SplitIPs[0] >= 1
    
		;; first element of array after Split is number of returned elements
		ReDim $HuntedIPs [$SplitIPs[0]]
		$IPList = ""
    
		For $r = 1 To UBound($SplitIPs) - 1
			if Not StringIsInt($SplitIPs[$r]) Then
				MsgBox(48,$VersionInfo,"Enter ips as integers in the format xx,yy,zz")
				$val = 1
			EndIf
			$HuntedIPs[$r - 1] = $SplitIPs[$r]  ;; copy IP into hunting list
			If $IPList = "" Then
				$IPList = $SplitIPs[$r]  ;; init to first split IP
			Else
				$IPList = $IPList & ", " & $SplitIPs[$r]
			EndIf
        
		Next
	WEnd
	GUICtrlSetData($IPListLabel, $IPList)
	$changedip = 1
EndFunc

; ===========================================

Func ChangeDelay()
	Do
        $value = InputBox($VersionInfo & ": Game duration", "Please enter how many seconds (at least 10) a game should last. Note: 180 seconds is generally a safe number to avoid getting IP banned after many tries.", $GameDurationSeconds, " M","","","","",30)
		if @error = 1 Then
			Return
		EndIf
    Until (($value >= 10) AND (StringIsInt($value)))
	$GameDurationSeconds = $value
	GUICtrlSetData($GameDurationLabel, $GameDurationSeconds & " seconds")
EndFunc

; ===========================================

Func PauseButton()
    
    If $HuntPaused = 0 Then
        Pause()
    Else
        UnPause()
    EndIf
    
EndFunc   ;==>PauseButton

; ===========================================

Func Pause()
    
    $HuntPaused = 1
    GUICtrlSetData($PauseButton, "Resume")
    $PausedText = GUICtrlRead($ProgressLabel) & " (paused)"
    GUICtrlSetData($ProgressLabel, $PausedText)
    GUICtrlSetBkColor($Progress, 0xff0000)
    
EndFunc   ;==>Pause

; ===========================================

Func UnPause()
    
    $HuntPaused = 0
    GUICtrlSetData($PauseButton, "Pause")
    $PausedText = ""
    GUICtrlSetBkColor($Progress, 0xffffff)
    ;; no need to update the label - it will get updated once game resumes
    
EndFunc   ;==>UnPause

; ===========================================

Func HoldAbandon()
	If $HoldGame = 0 Then
		Hold()
	Else
		Abandon()
	EndIf
    
EndFunc

; ===========================================

Func Hold()
    UnPause()
    $HoldGame = 1
    GUICtrlSetData($HoldAbandonButton, "Abandon Game")
;~ 	getgamenamepass()
    
EndFunc

; ===========================================

Func Abandon()
    UnPause()
	GUICtrlSetState($HoldAbandonButton,$GUI_DISABLE)
    $HoldGame = 0
	AppendLineToLogText("Abandoning the game")
	GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
    GUICtrlSetData($HoldAbandonButton, "Hold Game")
;~ 	ExitGame()
;~ 	AppendLineToLogText("Waiting " & $DelayBeforeNewGameSeconds & " seconds before creating game...")
;~ 	Sleep($DelayBeforeNewGameSeconds * 1000)
;~ 	VerifyLobbyScreenUp()
EndFunc

; ===========================================

Func CloseClicked()
    
    Exit
    
EndFunc   ;==>CloseClicked

; ========================================

Func CreateGame()
	VerifyLobbyScreenUp()    
    Do
        $GameCount = $GameCount + 1
        AppendLineToLogText( "Current try: " & $GameCount)
        If (GUICtrlRead($MinimizedCheckbox) = $GUI_UNCHECKED) Then ActivateRestoreDiabloWindow()
        ;; click Create button
        
		;; click "Join" button (to make sure "Create" will be active; it can be grayed out after create fails)
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y)
		Sleep(400)
		;; click "Create" button
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_CREATE_X, $LOBBY_MAIN_CREATE_Y)
		Sleep(400)
        ;; click Hell level button
        _MouseClickMinimized($WindowName, "left", $LOBBY_CREATE_X, $LOBBY_CREATE_Y)
		Sleep(400)
        
        ;; make game name and password
        $GameNumber = $GameNumber + 1
        $GameName = $UserUniqueGameName & $GameNumber
		if $UserUniqueGamePass = "" Then
			$GamePass = $GameNumber
		Else
			$GamePass = $UserUniqueGamePass
		EndIf
        AppendLineToLogText( "Trying to create " & $GameName & "//" & $GamePass)
        
        _SendMinimized($WindowName, $GameName & '{TAB}')
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, $GamePass)
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, '{ENTER}')
        ;; FOR DEBUGGING -> _SendMinimized($WindowName, $GamePass)
        
    Until IsGameCreated() = 1
    
    Return
    
EndFunc   ;==>CreateGame 

; ========================================

;; logic is a bit strange here...

Func IsGameCreated()
    
    ; init a timer, so we can see how long this takes (for recovery)
    $TimerStart = TimerInit()
    
    ;; WaitForChangeInManaBall (1000, 7)  ;; milliseconds between checks, number of retries
    
    $RetryCount = 0
    Do
        If IsGameActive() Then
            Return 1
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30
    
    
    ; Assume now that Game creation has failed and try to recover
    ; we only deal with "failed to join game" errors, so we assume that happened.
    ; All we can do is wait the gameduration or 40 seconds (so the screen goes away), because a game was created that we couldn't join
    if $GameDurationSeconds < 40 Then
		$InitSecondsRemaining = (40 - Int(TimerDiff($TimerStart) / 1000))
	Else
		$InitSecondsRemaining = ($GameDurationSeconds - Int(TimerDiff($TimerStart) / 1000))
	EndIf
    AppendLineToLogText("Problem creating and joining game... Waiting " & $InitSecondsRemaining & " seconds, because game was likely created and I was unable to join it.")
    Do
        $SecondsRemaining = ($GameDurationSeconds - Int(TimerDiff($TimerStart) / 1000))
        $percentComplete = Int(100 * ($InitSecondsRemaining - $SecondsRemaining) / $InitSecondsRemaining)
        
        GUICtrlSetData($ProgressLabel, "Time before next game:" & $SecondsRemaining & " sec.")
        GUICtrlSetData($Progress, $percentComplete)
        
        ;; beep to signal that the timer's about to run out
        If $SecondsRemaining <= 5 Then
            MyBeep()
        EndIf
        
        Sleep(1000)
        
    Until (TimerDiff($TimerStart) > $GameDurationSeconds * 1000)
    
    VerifyLobbyScreenUp()
    
    Return 0
    
EndFunc   ;==>IsGameCreated 

; ========================================

Func IsLobbyScreenUp()
    
    If GUICtrlRead($MinimizedCheckbox) = $GUI_UNCHECKED Then ActivateRestoreDiabloWindow()
    
    $ProcessID = GetD2ProcessID()
    
    Local $DllInformation = _MemoryOpen ($ProcessID)
    If @error Then
        MsgBox(4096, "ERROR", "Failed to open memory.")
        Exit
    EndIf
    
    $Value = _MemoryRead ($OFFSET_D2MULTI_SCREEN, $DllInformation, 'dword')
    
    ;; MsgBox(4096, "Value", $Value)
    
    ;##################################
    ;Close the process.
    ;##################################
    _MemoryClose ($DllInformation)
    If @error Then
        MsgBox(4096, "ERROR", "Failed to close memory.")
        Exit
    EndIf
    
    If $Value <> 0 Then
        Return 1
    Else
        Return 0
    EndIf
    
EndFunc   ;==>IsLobbyScreenUp 

; ========================================

Func VerifyLobbyScreenUp()
    
    If Not IsLobbyScreenUp() Then
        Do
            $userResponse = MsgBox(5 + 32 + 262144, $VersionInfo & ": Problem", "Either the Lobby Screen is not active in the Diablo II window, or the Create button is grayed out and I cannot create a game." & @CRLF & "Please make sure you've opened a character in Diablo and are waiting in the lobby screen, with the Create button present and enabled.")
            If $userResponse = 2 Then
                ;; user chose to cancel, exit...
                Exit
            EndIf
        Until IsLobbyScreenUp()
    Else
		GUICtrlSetState($HoldAbandonButton,$GUI_ENABLE)
        ;; everything is good, continue on
    EndIf
    
EndFunc   ;==>VerifyLobbyScreenUp 

; ========================================

Func GetD2ProcessID()
    $ProcID = WinGetProcess($WindowName, "")
    If $ProcID = -1 Then
        MsgBox(4096, "ERROR", "Diablo Game appears not to be running. Exiting...")
        Exit
    EndIf
    Return $ProcID
EndFunc   ;==>GetD2ProcessID

; ========================================

Func IsGameActive()
    
    ;; if game is active, then the game ping will be > 0
    
    $ping = ReadGamePing()
    If $ping > 0 Then
        Return 1
    Else
        Return 0
    EndIf
    
EndFunc   ;==>IsGameActive 

; ========================================

Func ReadGamePing()

    Local $Value

    Local $ProcessID = GetD2ProcessID()
	$value = Read_Diablo_Memory($ProcessID, $OFFSET_Game_Ping, 'dword')

	Return $Value
    
EndFunc   ;==>ReadGamePing 

; ========================================

Func IsIPFound($IP)
    ;; find last "." in IP address
    $lastDot = StringInStr($IP, ".", 0, 3)
    ;; find last part of IP address
    $lastPart = StringMid($IP, $lastDot + 1)
    
    ;; search for last part of IP in the HuntedIP array
    If $DebugForceFind Then
        $HuntedIPIsFound = 1
    Else
        $HuntedIPIsFound = 0
    EndIf
    
    For $r = 0 To UBound($HuntedIPs) - 1
        ;; MsgBox(4096, 'Comparing', "Comparing '" & $HuntedIPs[$r] & "' to '" & $lastPart & "'")
        If $HuntedIPs[$r] = $lastPart Then $HuntedIPIsFound = 1
    Next
    Return $HuntedIPIsFound
EndFunc   ;==>IsIPFound

; ========================================

Func ExitGame()
    $HoldGame = 0
	GUICtrlSetData($HoldAbandonButton, "Hold Game")
    AppendLineToLogText( "Trying to exit game...")
    ; ControlSetText ( $VersionInfo, "", "Static1", "Hunting IPs: " & $IPList & @CRLF & "Current try: " & $GameCount &@CRLF & "Trying to exit game...")
    
    If (GUICtrlRead($MinimizedCheckbox) = $GUI_UNCHECKED) Then
        ActivateRestoreDiabloWindow()
    EndIf
    
    ;; only try to exit if a game's not active
    
    If IsGameActive() Then
        _SendMinimized($WindowName, "{SPACE}{SPACE}{SPACE}")
        Sleep(100)
        
        _SendMinimized($WindowName, '{ESC}')
        Sleep(500)
		_SendMinimized($WindowName, '{UP}')
		Sleep(100)
		_SendMinimized($WindowName, '{ENTER}')
        
        ;; wait for screen to change
        $retries = 0
        While (Not IsLobbyScreenUp() And $retries < 20)
            Sleep(500)
            $retries = $retries + 1
        WEnd
        
    Else
        AppendLineToLogText( "Game is already inactive; attempting to continue without exiting.")
    EndIf
	If IsGameActive() Then
		AppendLineToLogText( "Failed to exit game. trying alternate method")
		_SendMinimized($WindowName, "{SPACE}{SPACE}{SPACE}")
        Sleep(100)
        
        _SendMinimized($WindowName, '{ESC}')
        Sleep(500)
        _MouseClickMinimized($WindowName, "left", 439, 259)  ;; coordinates of "Save and Exit Game"
		Sleep(500)
		_MouseClickMinimized($WindowName, "left", 439, 259)  ;; coordinates of "Save and Exit Game"
        
        ;; wait for screen to change
        $retries = 0
        While (Not IsLobbyScreenUp() And $retries < 20)
            Sleep(500)
            $retries = $retries + 1
        WEnd
	EndIf

    VerifyLobbyScreenUp()
    Return
    
EndFunc   ;==>ExitGame 

; ========================================

Func AckHuntedIPFound()
    $HoldGame = 1
	GUICtrlSetData($HoldAbandonButton, "Abandon Game")
    AppendLineToLogText("Hunted IP " & $CurrentIP & " has been found at " & _NowCalc() & @CRLF & "Game: " & $GameName & "//" & $GamePass)

    GUICtrlSetData($ProgressLabel, "Found IP " & $CurrentIP & "!")
    GUICtrlSetBkColor($ProgressLabel, 0x00FF00)

    ;; Give the user a chance to acknowledge the game has been found, NOT repeating the sound
	SoundPlay($FoundSoundFile)
	TrayTip("Success!!!", "Hunted IP " & $CurrentIP & " has been found!!!" & @CRLF & "Game name: " & $GameName & @CRLF & "Game password: " & $GamePass & @CRLF & "Currently anti-idling - will auto-rejoin if dropped.", "", 1)
    $ai = 0
	while not IsLobbyScreenUp()
		if $HoldGame = 0 Then
			ExitGame()
			AppendLineToLogText("Waiting " & $DelayBeforeNewGameSeconds & " seconds before creating game...")
			Sleep($DelayBeforeNewGameSeconds * 1000)
			VerifyLobbyScreenUp()
			_Main()
		EndIf
		$ai = $ai + 1
		;only do anti-idle every 30 seconds
		if $ai >= 30 Then
			$ai = 0
			AntiIdle()
		EndIf

        Sleep(1000)
    WEnd
    Sleep(500)
    RejoinLostGameIP()
    
    Return
    
EndFunc   ;==>AckHuntedIPFound 

; ========================================

Func RejoinLostGameIP()
	
        If (GUICtrlRead($MinimizedCheckbox) = $GUI_UNCHECKED) Then ActivateRestoreDiabloWindow()
        ;; click Create button
        
		;; click "Join" button
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y)
		Sleep(400)
        

        AppendLineToLogText( "Attempting to rejoin game: " & $GameName & "//" & $GamePass)
        
        _SendMinimized($WindowName, $GameName & '{TAB}')
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, $GamePass)
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, '{ENTER}')
        
        $RetryCount = 0
    Do
        If IsGameActive() Then
			AppendLineToLogText( "Successfilly rejoined game!")
            AckHuntedIPFound()
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30
	
	AppendLineToLogText( "Failed to rejoin game; Continuing hunting")
	GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
	_Main()
	
EndFunc

; ========================================

Func InterruptHunt()
    $HoldGame = 1
	GUICtrlSetData($HoldAbandonButton, "Abandon Game")
    AppendLineToLogText("Interrupting hunt because of detected activity on current server.")
    
    ;; adjust the progress bar and Pause button
    GUICtrlSetState($PauseButton, $GUI_DISABLE)
    GUICtrlSetData($ProgressLabel, "Interrupted - SoJ sales " & $CurrentIP)
    GUICtrlSetBkColor($ProgressLabel, 0x00FF00)
    GUICtrlSetData($Progress, 0)
    
    ;; Give the user a chance to acknowledge the game is being held, NOT repeating the sound
    SoundPlay($FoundSoundFile)
	TrayTip("Possible success!!!", "Chat messages indicate activity on " & $CurrentIP & @CRLF & "Game name: " & $GameName & @CRLF & "Game password: " & $GamePass & @CRLF & "Currently anti-idling - will auto-rejoin if dropped.", "", 1)
    $ai = 0
	while not IsLobbyScreenUp()
		if $HoldGame = 0 Then
			ExitGame()
			AppendLineToLogText("Waiting " & $DelayBeforeNewGameSeconds & " seconds before creating game...")
			Sleep($DelayBeforeNewGameSeconds * 1000)
			VerifyLobbyScreenUp()
			_Main()
		EndIf
		$ai = $ai + 1
		;only do anti-idle every 30 seconds
		if $ai >= 30 Then
			$ai = 0
			AntiIdle()
		EndIf

        Sleep(1000)
    WEnd
    Sleep(500)
    RejoinLostGameInt()
    
    Return
    
EndFunc   ;==>InterruptHunt 

; ============================================

Func RejoinLostGameInt()
	
        If (GUICtrlRead($MinimizedCheckbox) = $GUI_UNCHECKED) Then ActivateRestoreDiabloWindow()
        ;; click Create button
        
		;; click "Join" button
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y)
		Sleep(400)
        

        AppendLineToLogText( "Attempting to rejoin game: " & $GameName & "//" & $GamePass)
        
        _SendMinimized($WindowName, $GameName & '{TAB}')
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, $GamePass)
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, '{ENTER}')
        
        $RetryCount = 0
    Do
        If IsGameActive() Then
			AppendLineToLogText( "Successfilly rejoined game!")
            InterruptHunt()
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30
	
	AppendLineToLogText( "Failed to rejoin game; Continuing hunting")
	GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
	_Main()
	
EndFunc

; ========================================

Func HoldManualGame()
    $HoldGame = 1
	GUICtrlSetData($HoldAbandonButton, "Abandon Game")
    AppendLineToLogText("Holding game " & $GameName & "//" & $GamePass)
	$CurrentIP = Read_Diablo_Memory (GetD2ProcessID(), $OFFSET_D2MULTI_IPADDRESS_ASCII, 'char[16]')
	AppendLineToLogText("Held game ip is: " & $CurrentIP)
    
    ;; adjust the progress bar and Pause button
    GUICtrlSetState($PauseButton, $GUI_DISABLE)
    GUICtrlSetData($ProgressLabel, "Holding Ip " & $CurrentIP)
    GUICtrlSetBkColor($ProgressLabel, 0x00FF00)
    GUICtrlSetData($Progress, 0)
    
    ;; Give the user a chance to acknowledge the game is being held, no sound
    $ai = 0
	while not IsLobbyScreenUp()
		if $HoldGame = 0 Then
			ExitGame()
			AppendLineToLogText("Waiting " & $DelayBeforeNewGameSeconds & " seconds before creating game...")
			Sleep($DelayBeforeNewGameSeconds * 1000)
			VerifyLobbyScreenUp()
			_Main()
		EndIf
		$ai = $ai + 1
		;only do anti-idle every 30 seconds
		if $ai >= 30 Then
			$ai = 0
			AntiIdle()
			
		EndIf

        Sleep(1000)
    WEnd
    Sleep(500)
    
    RejoinLostGameHold()
    
    Return
    
EndFunc   ;==>InterruptHunt 

; ============================================

Func RejoinLostGameHold()
	
        If (GUICtrlRead($MinimizedCheckbox) = $GUI_UNCHECKED) Then ActivateRestoreDiabloWindow()
        ;; click Create button
        
		;; click "Join" button
        _MouseClickMinimized($WindowName, "left", $LOBBY_MAIN_JOIN_X, $LOBBY_MAIN_JOIN_Y)
		Sleep(400)
        

        AppendLineToLogText( "Attempting to rejoin game: " & $GameName & "//" & $GamePass)
        
        _SendMinimized($WindowName, $GameName & '{TAB}')
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, $GamePass)
        Sleep(500)  ;; changed from 250, since games were being created w/o password when d2 is minimized(strange?)
        _SendMinimized($WindowName, '{ENTER}')
        
        $RetryCount = 0
    Do
        If IsGameActive() Then
			AppendLineToLogText( "Successfilly rejoined game!")
            HoldManualGame()
        EndIf
        Sleep(1000)
        $RetryCount = $RetryCount + 1
    Until $RetryCount >= 30
	
	AppendLineToLogText( "Failed to rejoin game; Continuing hunting")
	GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
	_Main()
	
EndFunc

; ========================================

Func AntiIdle()
    
    If (GUICtrlRead($MinimizedCheckbox) = $GUI_UNCHECKED) Then ActivateRestoreDiabloWindow()
    
    If IsGameActive() Then
		;; anti-idle with random "vocal" message ("time to die!", etc.)
		_SendMinimized($WindowName, "{NUMPAD" & Random(0, 7, 1) & "}")
        SendSuccessMessage()
		_SendMinimized($WindowName, "{NUMPAD" & Random(0, 7, 1) & "}")
    Else
        AppendLineToLogText("Sorry. The game on the hunted IP " & $CurrentIP & " appears to have dropped (disconnected, crashed?) at " & _NowCalc())
		GUICtrlSetBkColor($ProgressLabel,0xFFFFFF)
;~         $userResponse = MsgBox(32, $VersionInfo & ": Problem", "Game " & $GameName & "//" & $GamePass & " appears to be lost (disconnected?). Check your Diablo II window.")
;~         Exit
    EndIf
    
EndFunc   ;==>AntiIdle 

; ============================================

Func SendSuccessMessage()
    
    _SendMinimized($WindowName, "{SPACE}{SPACE}{SPACE}")
    Sleep(250)
    
    ;; randomizing the message a bit with variable number of "!"
    
    If $PrivateMessageRecipient <> "" Then
        ;; note : if you don't bring the d2 window to front,
        ;; the success message (which is supposed to go to the
        ;; minimized window) doesn't work -
        ;; it stops after the first {enter}
		;; only does it if the game is set to not minimized
		If (GUICtrlRead($MinimizedCheckbox) = $GUI_UNCHECKED) Then
			ActivateRestoreDiabloWindow()
			_SendMinimized($WindowName, "{ENTER}")
			Sleep(250)
			_SendMinimized($WindowName, "/m *" & $PrivateMessageRecipient & " Come to " & $GameName & "//" & $GamePass & " for a game on " & $CurrentIP & _StringRepeat("{!}", Random(1, 9, 1)))
			_SendMinimized($WindowName, "{ENTER}")
		EndIf

    EndIf
    
EndFunc   ;==>SendSuccessMessage 

; ============================================

Func GetLastChatMessage()
    
    $Handle = _MemoryOpen (GetD2ProcessID())
    
    $pointer1 = _MemoryRead ($OFFSET_D2MULTI_LAST_CHAT_MSG, $Handle, 'dword')
    $pointer2 = _MemoryRead ($pointer1, $Handle, 'dword')
    $Temp = _MemoryReadWideString ($pointer2, $Handle, 'ushort[256]')
    
    _MemoryClose ($Handle)
    
    Return $Temp
    
EndFunc   ;==>GetLastChatMessage


; ============================================

Func AppendLineToLogText($TextToAppend)
	_GUICtrlEdit_AppendText($LogText,$TextToAppend & @CRLF)
EndFunc   ;==>AppendLineToLogText

; ============================================

Func MyBeep()
    
    ;Found this on the AutoIt forums...
    
    ;Define             Value   Sound Alias
    ;Default beep       -1
    ;MB_OK              0x00    SystemDefault
    ;MB_ICONHAND        0x10    SystemHand
    ;MB_ICONQUESTION    0x20    SystemQuestion
    ;MB_ICONEXCLAMATION 0x30    SystemExclamation
    ;MB_ICONASTERISK    0x40    SystemAsterisk
    
    ;call BOOL MessageBeep(UINT uType);
	
	If (GUICtrlRead($DisableBeepCheckbox) = $GUI_UNCHECKED) Then
		DllCall("user32.dll", "int", "MessageBeep", "int", -1)
	EndIf
    
EndFunc   ;==>MyBeep 

;===============================================================================
;
; Function Name:  _SendMinimized()
;===============================================================================
Func _SendMinimized($Window, $keys)
    ;; note : testing with D2 shows that sending {ENTER} to open the chat screen
    ;;   requires that the D2 window be shown. Otherwise, all other keystrokes
    ;;   seem to be ingored, and the client stays in the chat mode.
	_SendMinimizedMessage(WinGetHandle($Window),$keys)
    
EndFunc   ;==>_SendMinimized

;========================================================

Func _ProcessGetLoadedModules($iPID)
    Local Const $PROCESS_QUERY_INFORMATION=0x0400
    Local Const $PROCESS_VM_READ=0x0010
    Local $aCall, $hPsapi=DllOpen("Psapi.dll")
    Local $hProcess, $tModulesStruct
    $tModulesStruct=DllStructCreate("hwnd [200]")
    Local $SIZEOFHWND = DllStructGetSize($tModulesStruct)/200
    $hProcess=_WinAPI_OpenProcess(BitOR($PROCESS_QUERY_INFORMATION,$PROCESS_VM_READ),False,$iPID)
    If Not $hProcess Then Return SetError(1,0,-1)
    $aCall=DllCall($hPsapi,"int","EnumProcessModules","ptr",$hProcess,"ptr",DllStructGetPtr($tModulesStruct),"dword",DllStructGetSize($tModulesStruct),"dword*","")
    If $aCall[4]>DllStructGetSize($tModulesStruct) Then
        $tModulesStruct=DllStructCreate("hwnd ["&$aCall[4]/$SIZEOFHWND&"]")
        $aCall=DllCall($hPsapi,"int","EnumProcessModules","ptr",$hProcess,"ptr",DllStructGetPtr($tModulesStruct),"dword",$aCall[4],"dword*","")
    EndIf
    Local $aReturn[$aCall[4]/$SIZEOFHWND]
	Local $returnval = 0
    For $i=0 To Ubound($aReturn)-1
        $aCall=DllCall($hPsapi,"dword","GetModuleFileNameExW","ptr",$hProcess,"int",DllStructGetData($tModulesStruct,1,$i+1),"wstr","","dword",65536)
		if (StringRight($aCall[3]	,13) = "\d2client.dll") Then
;~ 			MsgBox(0,$i,$aCall[3] & @CRLF & DllStructGetData($tModulesStruct,1,$i+1))
			$returnval = DllStructGetData($tModulesStruct,1,$i+1)
		EndIf	
        $aReturn[$i]=$aCall[3]
    Next
    _WinAPI_CloseHandle($hProcess)
    DllClose($hPsapi)
    Return $returnval
EndFunc

Func _winrename()
	AutoItSetOption("WinTitleMatchMode", 3)  ;; exact match
	$winarray1 = WinList("Diablo II")
	for $i = 1 to $winarray1[0][0]
		$j = 1
		while $j < 100
			$winarray2 = WinList("Diablo II-" & $j)
			if $winarray2[0][0] = 0 Then
				WinSetTitle($winarray1[$i][1],"","Diablo II-" & $j)
				$j = 100
			EndIf
			$j = $j + 1
		WEnd
	Next
	MsgBox(0,$VersionInfo,"All 'Diablo II' windows have been renamed")
EndFunc

;=====================================================================
; by PortalDeamon000
Func _Update()
	FileDelete(@ScriptDir & "\version.dat")
	InetGet("http://www.portaldeamon.com/VersionKCH.txt", @ScriptDir & "\version.dat", 1, 0)
	$version = FileRead(@ScriptDir & "\version.dat")
	if FileGetSize(@ScriptDir & "\version.dat") <> 19 Then
		FileDelete(@ScriptDir & "\version.dat")
		MsgBox(48, "Updater", "ERROR!" & @CRLF & "Update Site Not Found")
		Return
	EndIf
	if $version = $VersionInfo Then
		FileDelete(@ScriptDir & "\version.dat")
		MsgBox(0, "Updater", "No New Updates")
		Return
	Else
		FileDelete(@ScriptDir & "\version.dat")
		$return = MsgBox(49, $VersionInfo, $version & " is avaiable for download." & @CRLF & "Click OK to download." )
		if $return = 1 Then ShellExecute("http://www.portaldeamon.com/kch_latest_release.zip")
		Return
	EndIf
EndFunc